@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * P2SVpnGateway Resource.
 * @property customDnsServers List of all customer specified DNS servers IP addresses.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property isRoutingPreferenceInternet Enable Routing Preference property for the Public IP Interface of the P2SVpnGateway.
 * @property location Resource location.
 * @property name Resource name.
 * @property p2SConnectionConfigurations List of all p2s connection configurations of the gateway.
 * @property provisioningState The provisioning state of the P2S VPN gateway resource.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualHub The VirtualHub to which the gateway belongs.
 * @property vpnClientConnectionHealth All P2S VPN clients' connection health status.
 * @property vpnGatewayScaleUnit The scale unit for this p2s vpn gateway.
 * @property vpnServerConfiguration The VpnServerConfiguration to which the p2sVpnGateway is attached to.
 */
public data class GetP2sVpnGatewayResult(
    public val customDnsServers: List<String>? = null,
    public val etag: String,
    public val id: String? = null,
    public val isRoutingPreferenceInternet: Boolean? = null,
    public val location: String,
    public val name: String,
    public val p2SConnectionConfigurations: List<P2SConnectionConfigurationResponse>? = null,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualHub: SubResourceResponse? = null,
    public val vpnClientConnectionHealth: VpnClientConnectionHealthResponse,
    public val vpnGatewayScaleUnit: Int? = null,
    public val vpnServerConfiguration: SubResourceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetP2sVpnGatewayResult): GetP2sVpnGatewayResult = GetP2sVpnGatewayResult(
            customDnsServers = javaType.customDnsServers().map({ args0 -> args0 }),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            isRoutingPreferenceInternet = javaType.isRoutingPreferenceInternet().map({ args0 ->
                args0
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            p2SConnectionConfigurations = javaType.p2SConnectionConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.P2SConnectionConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualHub = javaType.virtualHub().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            vpnClientConnectionHealth = javaType.vpnClientConnectionHealth().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.VpnClientConnectionHealthResponse.Companion.toKotlin(args0)
            }),
            vpnGatewayScaleUnit = javaType.vpnGatewayScaleUnit().map({ args0 -> args0 }).orElse(null),
            vpnServerConfiguration = javaType.vpnServerConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
