@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * P2SVpnServerConfiguration Resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the P2SVpnServerConfiguration that is unique within a VirtualWan in a resource group. This name can be used to access the resource along with Paren VirtualWan resource name.
 * @property p2SVpnGateways List of references to P2SVpnGateways.
 * @property p2SVpnServerConfigRadiusClientRootCertificates Radius client root certificate of P2SVpnServerConfiguration.
 * @property p2SVpnServerConfigRadiusServerRootCertificates Radius Server root certificate of P2SVpnServerConfiguration.
 * @property p2SVpnServerConfigVpnClientRevokedCertificates VPN client revoked certificate of P2SVpnServerConfiguration.
 * @property p2SVpnServerConfigVpnClientRootCertificates VPN client root certificate of P2SVpnServerConfiguration.
 * @property provisioningState The provisioning state of the P2S VPN server configuration resource.
 * @property radiusServerAddress The radius server address property of the P2SVpnServerConfiguration resource for point to site client connection.
 * @property radiusServerSecret The radius secret property of the P2SVpnServerConfiguration resource for point to site client connection.
 * @property vpnClientIpsecPolicies VpnClientIpsecPolicies for P2SVpnServerConfiguration.
 * @property vpnProtocols VPN protocols for the P2SVpnServerConfiguration.
 */
public data class GetP2sVpnServerConfigurationResult(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val p2SVpnGateways: List<SubResourceResponse>,
    public val p2SVpnServerConfigRadiusClientRootCertificates: List<P2SVpnServerConfigRadiusClientRootCertificateResponse>? = null,
    public val p2SVpnServerConfigRadiusServerRootCertificates: List<P2SVpnServerConfigRadiusServerRootCertificateResponse>? = null,
    public val p2SVpnServerConfigVpnClientRevokedCertificates: List<P2SVpnServerConfigVpnClientRevokedCertificateResponse>? = null,
    public val p2SVpnServerConfigVpnClientRootCertificates: List<P2SVpnServerConfigVpnClientRootCertificateResponse>? = null,
    public val provisioningState: String,
    public val radiusServerAddress: String? = null,
    public val radiusServerSecret: String? = null,
    public val vpnClientIpsecPolicies: List<IpsecPolicyResponse>? = null,
    public val vpnProtocols: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetP2sVpnServerConfigurationResult): GetP2sVpnServerConfigurationResult = GetP2sVpnServerConfigurationResult(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            p2SVpnGateways = javaType.p2SVpnGateways().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            p2SVpnServerConfigRadiusClientRootCertificates = javaType.p2SVpnServerConfigRadiusClientRootCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.P2SVpnServerConfigRadiusClientRootCertificateResponse.Companion.toKotlin(args0)
                })
            }),
            p2SVpnServerConfigRadiusServerRootCertificates = javaType.p2SVpnServerConfigRadiusServerRootCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.P2SVpnServerConfigRadiusServerRootCertificateResponse.Companion.toKotlin(args0)
                })
            }),
            p2SVpnServerConfigVpnClientRevokedCertificates = javaType.p2SVpnServerConfigVpnClientRevokedCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.P2SVpnServerConfigVpnClientRevokedCertificateResponse.Companion.toKotlin(args0)
                })
            }),
            p2SVpnServerConfigVpnClientRootCertificates = javaType.p2SVpnServerConfigVpnClientRootCertificates().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.P2SVpnServerConfigVpnClientRootCertificateResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            radiusServerAddress = javaType.radiusServerAddress().map({ args0 -> args0 }).orElse(null),
            radiusServerSecret = javaType.radiusServerSecret().map({ args0 -> args0 }).orElse(null),
            vpnClientIpsecPolicies = javaType.vpnClientIpsecPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.IpsecPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            vpnProtocols = javaType.vpnProtocols().map({ args0 -> args0 }),
        )
    }
}
