@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Defines web application firewall policy.
 * @property customRules Describes custom rules inside the policy.
 * @property etag Gets a unique read-only string that changes whenever the resource is updated.
 * @property frontendEndpointLinks Describes Frontend Endpoints associated with this Web Application Firewall policy.
 * @property id Resource ID.
 * @property location Resource location.
 * @property managedRules Describes managed rules inside the policy.
 * @property name Resource name.
 * @property policySettings Describes settings for the policy.
 * @property provisioningState Provisioning state of the policy.
 * @property resourceState
 * @property routingRuleLinks Describes Routing Rules associated with this Web Application Firewall policy.
 * @property securityPolicyLinks Describes Security Policy associated with this Web Application Firewall policy.
 * @property sku The pricing tier of web application firewall policy. Defaults to Classic_AzureFrontDoor if not specified.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetPolicyResult(
    public val customRules: CustomRuleListResponse? = null,
    public val etag: String? = null,
    public val frontendEndpointLinks: List<FrontendEndpointLinkResponse>,
    public val id: String,
    public val location: String? = null,
    public val managedRules: ManagedRuleSetListResponse? = null,
    public val name: String,
    public val policySettings: FrontDoorPolicySettingsResponse? = null,
    public val provisioningState: String,
    public val resourceState: String,
    public val routingRuleLinks: List<RoutingRuleLinkResponse>,
    public val securityPolicyLinks: List<SecurityPolicyLinkResponse>,
    public val sku: SkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetPolicyResult): GetPolicyResult = GetPolicyResult(
            customRules = javaType.customRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.CustomRuleListResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            frontendEndpointLinks = javaType.frontendEndpointLinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FrontendEndpointLinkResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            managedRules = javaType.managedRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ManagedRuleSetListResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            policySettings = javaType.policySettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FrontDoorPolicySettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceState = javaType.resourceState(),
            routingRuleLinks = javaType.routingRuleLinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RoutingRuleLinkResponse.Companion.toKotlin(args0)
                })
            }),
            securityPolicyLinks = javaType.securityPolicyLinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SecurityPolicyLinkResponse.Companion.toKotlin(args0)
                })
            }),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
