@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Private dns zone group resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property privateDnsZoneConfigs A collection of private dns zone configurations of the private dns zone group.
 * @property provisioningState The provisioning state of the private dns zone group resource.
 */
public data class GetPrivateDnsZoneGroupResult(
    public val etag: String,
    public val id: String? = null,
    public val name: String? = null,
    public val privateDnsZoneConfigs: List<PrivateDnsZoneConfigResponse>? = null,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetPrivateDnsZoneGroupResult): GetPrivateDnsZoneGroupResult = GetPrivateDnsZoneGroupResult(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            privateDnsZoneConfigs = javaType.privateDnsZoneConfigs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PrivateDnsZoneConfigResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
        )
    }
}
