@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Describes a virtual network link.
 * @property etag ETag of the virtual network link.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property metadata Metadata attached to the virtual network link.
 * @property name The name of the resource
 * @property provisioningState The current provisioning state of the virtual network link. This is a read-only property and any attempt to set this value will be ignored.
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 * @property virtualNetwork The reference to the virtual network. This cannot be changed after creation.
 */
public data class GetPrivateResolverVirtualNetworkLinkResult(
    public val etag: String,
    public val id: String,
    public val metadata: Map<String, String>? = null,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
    public val virtualNetwork: SubResourceResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetPrivateResolverVirtualNetworkLinkResult): GetPrivateResolverVirtualNetworkLinkResult = GetPrivateResolverVirtualNetworkLinkResult(
            etag = javaType.etag(),
            id = javaType.id(),
            metadata = javaType.metadata().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
            virtualNetwork = javaType.virtualNetwork().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
