@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Class representing a Traffic Manager profile.
 * @property allowedEndpointRecordTypes The list of allowed endpoint record types.
 * @property dnsConfig The DNS settings of the Traffic Manager profile.
 * @property endpoints The list of endpoints in the Traffic Manager profile.
 * @property id Fully qualified resource Id for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/trafficManagerProfiles/{resourceName}
 * @property location The Azure Region where the resource lives
 * @property maxReturn Maximum number of endpoints to be returned for MultiValue routing type.
 * @property monitorConfig The endpoint monitoring settings of the Traffic Manager profile.
 * @property name The name of the resource
 * @property profileStatus The status of the Traffic Manager profile.
 * @property tags Resource tags.
 * @property trafficRoutingMethod The traffic routing method of the Traffic Manager profile.
 * @property trafficViewEnrollmentStatus Indicates whether Traffic View is 'Enabled' or 'Disabled' for the Traffic Manager profile. Null, indicates 'Disabled'. Enabling this feature will increase the cost of the Traffic Manage profile.
 * @property type The type of the resource. Ex- Microsoft.Network/trafficManagerProfiles.
 */
public data class GetProfileResult(
    public val allowedEndpointRecordTypes: List<String>? = null,
    public val dnsConfig: DnsConfigResponse? = null,
    public val endpoints: List<EndpointResponse>? = null,
    public val id: String? = null,
    public val location: String? = null,
    public val maxReturn: Double? = null,
    public val monitorConfig: MonitorConfigResponse? = null,
    public val name: String? = null,
    public val profileStatus: String? = null,
    public val tags: Map<String, String>? = null,
    public val trafficRoutingMethod: String? = null,
    public val trafficViewEnrollmentStatus: String? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetProfileResult): GetProfileResult = GetProfileResult(
            allowedEndpointRecordTypes = javaType.allowedEndpointRecordTypes().map({ args0 -> args0 }),
            dnsConfig = javaType.dnsConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.DnsConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            endpoints = javaType.endpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.EndpointResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            maxReturn = javaType.maxReturn().map({ args0 -> args0 }).orElse(null),
            monitorConfig = javaType.monitorConfig().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.MonitorConfigResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            profileStatus = javaType.profileStatus().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            trafficRoutingMethod = javaType.trafficRoutingMethod().map({ args0 -> args0 }).orElse(null),
            trafficViewEnrollmentStatus = javaType.trafficViewEnrollmentStatus().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
