@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Public IP address resource.
 * @property ddosSettings The DDoS protection custom policy associated with the public IP address.
 * @property deleteOption Specify what happens to the public IP address when the VM using it is deleted
 * @property dnsSettings The FQDN of the DNS record associated with the public IP address.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property extendedLocation The extended location of the public ip address.
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The idle timeout of the public IP address.
 * @property ipAddress The IP address associated with the public IP address resource.
 * @property ipConfiguration The IP configuration associated with the public IP address.
 * @property ipTags The list of tags associated with the public IP address.
 * @property linkedPublicIPAddress The linked public IP address of the public IP address resource.
 * @property location Resource location.
 * @property migrationPhase Migration phase of Public IP Address.
 * @property name Resource name.
 * @property natGateway The NatGateway for the Public IP address.
 * @property provisioningState The provisioning state of the public IP address resource.
 * @property publicIPAddressVersion The public IP address version.
 * @property publicIPAllocationMethod The public IP address allocation method.
 * @property publicIPPrefix The Public IP Prefix this Public IP Address should be allocated from.
 * @property resourceGuid The resource GUID property of the public IP address resource.
 * @property servicePublicIPAddress The service public IP address of the public IP address resource.
 * @property sku The public IP address SKU.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property zones A list of availability zones denoting the IP allocated for the resource needs to come from.
 */
public data class GetPublicIPAddressResult(
    public val ddosSettings: DdosSettingsResponse? = null,
    public val deleteOption: String? = null,
    public val dnsSettings: PublicIPAddressDnsSettingsResponse? = null,
    public val etag: String,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val id: String? = null,
    public val idleTimeoutInMinutes: Int? = null,
    public val ipAddress: String? = null,
    public val ipConfiguration: IPConfigurationResponse,
    public val ipTags: List<IpTagResponse>? = null,
    public val linkedPublicIPAddress: PublicIPAddressResponse? = null,
    public val location: String? = null,
    public val migrationPhase: String? = null,
    public val name: String,
    public val natGateway: NatGatewayResponse? = null,
    public val provisioningState: String,
    public val publicIPAddressVersion: String? = null,
    public val publicIPAllocationMethod: String? = null,
    public val publicIPPrefix: SubResourceResponse? = null,
    public val resourceGuid: String,
    public val servicePublicIPAddress: PublicIPAddressResponse? = null,
    public val sku: PublicIPAddressSkuResponse? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetPublicIPAddressResult): GetPublicIPAddressResult = GetPublicIPAddressResult(
            ddosSettings = javaType.ddosSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.DdosSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            deleteOption = javaType.deleteOption().map({ args0 -> args0 }).orElse(null),
            dnsSettings = javaType.dnsSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressDnsSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            idleTimeoutInMinutes = javaType.idleTimeoutInMinutes().map({ args0 -> args0 }).orElse(null),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            ipConfiguration = javaType.ipConfiguration().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.IPConfigurationResponse.Companion.toKotlin(args0)
            }),
            ipTags = javaType.ipTags().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.IpTagResponse.Companion.toKotlin(args0)
                })
            }),
            linkedPublicIPAddress = javaType.linkedPublicIPAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            migrationPhase = javaType.migrationPhase().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            natGateway = javaType.natGateway().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NatGatewayResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            publicIPAddressVersion = javaType.publicIPAddressVersion().map({ args0 -> args0 }).orElse(null),
            publicIPAllocationMethod = javaType.publicIPAllocationMethod().map({ args0 -> args0 }).orElse(null),
            publicIPPrefix = javaType.publicIPPrefix().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            resourceGuid = javaType.resourceGuid(),
            servicePublicIPAddress = javaType.servicePublicIPAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
