@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Route Filter Resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property ipv6Peerings A collection of references to express route circuit ipv6 peerings.
 * @property location Resource location.
 * @property name Resource name.
 * @property peerings A collection of references to express route circuit peerings.
 * @property provisioningState The provisioning state of the route filter resource.
 * @property rules Collection of RouteFilterRules contained within a route filter.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetRouteFilterResult(
    public val etag: String,
    public val id: String? = null,
    public val ipv6Peerings: List<ExpressRouteCircuitPeeringResponse>,
    public val location: String,
    public val name: String,
    public val peerings: List<ExpressRouteCircuitPeeringResponse>,
    public val provisioningState: String,
    public val rules: List<RouteFilterRuleResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetRouteFilterResult): GetRouteFilterResult = GetRouteFilterResult(
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipv6Peerings = javaType.ipv6Peerings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location(),
            name = javaType.name(),
            peerings = javaType.peerings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExpressRouteCircuitPeeringResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RouteFilterRuleResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
