@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Security Partner Provider resource.
 * @property connectionStatus The connection status with the Security Partner Provider.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the Security Partner Provider resource.
 * @property securityProviderName The security provider name.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualHub The virtualHub to which the Security Partner Provider belongs.
 */
public data class GetSecurityPartnerProviderResult(
    public val connectionStatus: String,
    public val etag: String,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val securityProviderName: String? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualHub: SubResourceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetSecurityPartnerProviderResult): GetSecurityPartnerProviderResult = GetSecurityPartnerProviderResult(
            connectionStatus = javaType.connectionStatus(),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            securityProviderName = javaType.securityProviderName().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualHub = javaType.virtualHub().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
