@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Service End point policy resource.
 * @property contextualServiceEndpointPolicies A collection of contextual service endpoint policy.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property kind Kind of service endpoint policy. This is metadata used for the Azure portal experience.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the service endpoint policy resource.
 * @property resourceGuid The resource GUID property of the service endpoint policy resource.
 * @property serviceAlias The alias indicating if the policy belongs to a service
 * @property serviceEndpointPolicyDefinitions A collection of service endpoint policy definitions of the service endpoint policy.
 * @property subnets A collection of references to subnets.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class GetServiceEndpointPolicyResult(
    public val contextualServiceEndpointPolicies: List<String>? = null,
    public val etag: String,
    public val id: String? = null,
    public val kind: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val serviceAlias: String? = null,
    public val serviceEndpointPolicyDefinitions: List<ServiceEndpointPolicyDefinitionResponse>? =
        null,
    public val subnets: List<SubnetResponse>,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetServiceEndpointPolicyResult): GetServiceEndpointPolicyResult = GetServiceEndpointPolicyResult(
            contextualServiceEndpointPolicies = javaType.contextualServiceEndpointPolicies().map({ args0 ->
                args0
            }),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            serviceAlias = javaType.serviceAlias().map({ args0 -> args0 }).orElse(null),
            serviceEndpointPolicyDefinitions = javaType.serviceEndpointPolicyDefinitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ServiceEndpointPolicyDefinitionResponse.Companion.toKotlin(args0)
                })
            }),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
