@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Subnet in a virtual network resource.
 * @property addressPrefix The address prefix for the subnet.
 * @property addressPrefixes List of address prefixes for the subnet.
 * @property applicationGatewayIPConfigurations Application gateway IP configurations of virtual network resource.
 * @property delegations An array of references to the delegations on the subnet.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property ipAllocations Array of IpAllocation which reference this subnet.
 * @property ipConfigurationProfiles Array of IP configuration profiles which reference this subnet.
 * @property ipConfigurations An array of references to the network interface IP configurations using subnet.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property natGateway Nat gateway associated with this subnet.
 * @property networkSecurityGroup The reference to the NetworkSecurityGroup resource.
 * @property privateEndpointNetworkPolicies Enable or Disable apply network policies on private end point in the subnet.
 * @property privateEndpoints An array of references to private endpoints.
 * @property privateLinkServiceNetworkPolicies Enable or Disable apply network policies on private link service in the subnet.
 * @property provisioningState The provisioning state of the subnet resource.
 * @property purpose A read-only string identifying the intention of use for this subnet based on delegations and other user-defined properties.
 * @property resourceNavigationLinks An array of references to the external resources using subnet.
 * @property routeTable The reference to the RouteTable resource.
 * @property serviceAssociationLinks An array of references to services injecting into this subnet.
 * @property serviceEndpointPolicies An array of service endpoint policies.
 * @property serviceEndpoints An array of service endpoints.
 * @property type Resource type.
 */
public data class GetSubnetResult(
    public val addressPrefix: String? = null,
    public val addressPrefixes: List<String>? = null,
    public val applicationGatewayIPConfigurations: List<ApplicationGatewayIPConfigurationResponse>? =
        null,
    public val delegations: List<DelegationResponse>? = null,
    public val etag: String,
    public val id: String? = null,
    public val ipAllocations: List<SubResourceResponse>? = null,
    public val ipConfigurationProfiles: List<IPConfigurationProfileResponse>,
    public val ipConfigurations: List<IPConfigurationResponse>,
    public val name: String? = null,
    public val natGateway: SubResourceResponse? = null,
    public val networkSecurityGroup: NetworkSecurityGroupResponse? = null,
    public val privateEndpointNetworkPolicies: String? = null,
    public val privateEndpoints: List<PrivateEndpointResponse>,
    public val privateLinkServiceNetworkPolicies: String? = null,
    public val provisioningState: String,
    public val purpose: String,
    public val resourceNavigationLinks: List<ResourceNavigationLinkResponse>,
    public val routeTable: RouteTableResponse? = null,
    public val serviceAssociationLinks: List<ServiceAssociationLinkResponse>,
    public val serviceEndpointPolicies: List<ServiceEndpointPolicyResponse>? = null,
    public val serviceEndpoints: List<ServiceEndpointPropertiesFormatResponse>? = null,
    public val type: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetSubnetResult): GetSubnetResult = GetSubnetResult(
            addressPrefix = javaType.addressPrefix().map({ args0 -> args0 }).orElse(null),
            addressPrefixes = javaType.addressPrefixes().map({ args0 -> args0 }),
            applicationGatewayIPConfigurations = javaType.applicationGatewayIPConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            delegations = javaType.delegations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.DelegationResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipAllocations = javaType.ipAllocations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            ipConfigurationProfiles = javaType.ipConfigurationProfiles().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.IPConfigurationProfileResponse.Companion.toKotlin(args0)
                })
            }),
            ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.IPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            natGateway = javaType.natGateway().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            networkSecurityGroup = javaType.networkSecurityGroup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkSecurityGroupResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            privateEndpointNetworkPolicies = javaType.privateEndpointNetworkPolicies().map({ args0 ->
                args0
            }).orElse(null),
            privateEndpoints = javaType.privateEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
                })
            }),
            privateLinkServiceNetworkPolicies = javaType.privateLinkServiceNetworkPolicies().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            purpose = javaType.purpose(),
            resourceNavigationLinks = javaType.resourceNavigationLinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ResourceNavigationLinkResponse.Companion.toKotlin(args0)
                })
            }),
            routeTable = javaType.routeTable().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.RouteTableResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            serviceAssociationLinks = javaType.serviceAssociationLinks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ServiceAssociationLinkResponse.Companion.toKotlin(args0)
                })
            }),
            serviceEndpointPolicies = javaType.serviceEndpointPolicies().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ServiceEndpointPolicyResponse.Companion.toKotlin(args0)
                })
            }),
            serviceEndpoints = javaType.serviceEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ServiceEndpointPropertiesFormatResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
        )
    }
}
