@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Network Manager Connection resource
 * @property description A description of the network manager connection.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Resource name.
 * @property networkManagerId Network Manager Id.
 * @property systemData The system metadata related to this resource.
 * @property type Resource type.
 */
public data class GetSubscriptionNetworkManagerConnectionResult(
    public val description: String? = null,
    public val etag: String,
    public val id: String,
    public val name: String,
    public val networkManagerId: String? = null,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetSubscriptionNetworkManagerConnectionResult): GetSubscriptionNetworkManagerConnectionResult =
            GetSubscriptionNetworkManagerConnectionResult(
                description = javaType.description().map({ args0 -> args0 }).orElse(null),
                etag = javaType.etag(),
                id = javaType.id(),
                name = javaType.name(),
                networkManagerId = javaType.networkManagerId().map({ args0 -> args0 }).orElse(null),
                systemData = javaType.systemData().let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
                }),
                type = javaType.type(),
            )
    }
}
