@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Defines the user rule collection.
 * @property appliesToGroups Groups for configuration
 * @property description A description of the user rule collection.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the resource.
 * @property systemData The system metadata related to this resource.
 * @property type Resource type.
 */
public data class GetUserRuleCollectionResult(
    public val appliesToGroups: List<NetworkManagerSecurityGroupItemResponse>,
    public val description: String? = null,
    public val etag: String,
    public val id: String,
    public val name: String,
    public val provisioningState: String,
    public val systemData: SystemDataResponse,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetUserRuleCollectionResult): GetUserRuleCollectionResult = GetUserRuleCollectionResult(
            appliesToGroups = javaType.appliesToGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkManagerSecurityGroupItemResponse.Companion.toKotlin(args0)
                })
            }),
            description = javaType.description().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
