@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * An IPSec parameters for a virtual network gateway P2S connection.
 * @property dhGroup The DH Group used in IKE Phase 1 for initial SA.
 * @property ikeEncryption The IKE encryption algorithm (IKE phase 2).
 * @property ikeIntegrity The IKE integrity algorithm (IKE phase 2).
 * @property ipsecEncryption The IPSec encryption algorithm (IKE phase 1).
 * @property ipsecIntegrity The IPSec integrity algorithm (IKE phase 1).
 * @property pfsGroup The Pfs Group used in IKE Phase 2 for new child SA.
 * @property saDataSizeKilobytes The IPSec Security Association (also called Quick Mode or Phase 2 SA) payload size in KB for P2S client..
 * @property saLifeTimeSeconds The IPSec Security Association (also called Quick Mode or Phase 2 SA) lifetime in seconds for P2S client.
 */
public data class GetVirtualNetworkGatewayVpnclientIpsecParametersResult(
    public val dhGroup: String,
    public val ikeEncryption: String,
    public val ikeIntegrity: String,
    public val ipsecEncryption: String,
    public val ipsecIntegrity: String,
    public val pfsGroup: String,
    public val saDataSizeKilobytes: Int,
    public val saLifeTimeSeconds: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVirtualNetworkGatewayVpnclientIpsecParametersResult): GetVirtualNetworkGatewayVpnclientIpsecParametersResult =
            GetVirtualNetworkGatewayVpnclientIpsecParametersResult(
                dhGroup = javaType.dhGroup(),
                ikeEncryption = javaType.ikeEncryption(),
                ikeIntegrity = javaType.ikeIntegrity(),
                ipsecEncryption = javaType.ipsecEncryption(),
                ipsecIntegrity = javaType.ipsecIntegrity(),
                pfsGroup = javaType.pfsGroup(),
                saDataSizeKilobytes = javaType.saDataSizeKilobytes(),
                saLifeTimeSeconds = javaType.saLifeTimeSeconds(),
            )
    }
}
