@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Describes a link to virtual network for a Private DNS zone.
 * @property etag The ETag of the virtual network link.
 * @property id Fully qualified resource Id for the resource. Example - '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/privateDnsZones/{privateDnsZoneName}'.
 * @property location The Azure Region where the resource lives
 * @property name The name of the resource
 * @property provisioningState The provisioning state of the resource. This is a read-only property and any attempt to set this value will be ignored.
 * @property registrationEnabled Is auto-registration of virtual machine records in the virtual network in the Private DNS zone enabled?
 * @property tags Resource tags.
 * @property type The type of the resource. Example - 'Microsoft.Network/privateDnsZones'.
 * @property virtualNetwork The reference of the virtual network.
 * @property virtualNetworkLinkState The status of the virtual network link to the Private DNS zone. Possible values are 'InProgress' and 'Done'. This is a read-only property and any attempt to set this value will be ignored.
 */
public data class GetVirtualNetworkLinkResult(
    public val etag: String? = null,
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val registrationEnabled: Boolean? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualNetwork: SubResourceResponse? = null,
    public val virtualNetworkLinkState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVirtualNetworkLinkResult): GetVirtualNetworkLinkResult = GetVirtualNetworkLinkResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            registrationEnabled = javaType.registrationEnabled().map({ args0 -> args0 }).orElse(null),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualNetwork = javaType.virtualNetwork().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            virtualNetworkLinkState = javaType.virtualNetworkLinkState(),
        )
    }
}
