@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Virtual Network resource.
 * @property addressSpace The AddressSpace that contains an array of IP address ranges that can be used by subnets.
 * @property bgpCommunities Bgp Communities sent over ExpressRoute with each route corresponding to a prefix in this VNET.
 * @property ddosProtectionPlan The DDoS protection plan associated with the virtual network.
 * @property dhcpOptions The dhcpOptions that contains an array of DNS servers available to VMs deployed in the virtual network.
 * @property enableDdosProtection Indicates if DDoS protection is enabled for all the protected resources in the virtual network. It requires a DDoS protection plan associated with the resource.
 * @property enableVmProtection Indicates if VM protection is enabled for all the subnets in the virtual network.
 * @property encryption Indicates if encryption is enabled on virtual network and if VM without encryption is allowed in encrypted VNet.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property extendedLocation The extended location of the virtual network.
 * @property flowLogs A collection of references to flow log resources.
 * @property flowTimeoutInMinutes The FlowTimeout value (in minutes) for the Virtual Network
 * @property id Resource ID.
 * @property ipAllocations Array of IpAllocation which reference this VNET.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the virtual network resource.
 * @property resourceGuid The resourceGuid property of the Virtual Network resource.
 * @property subnets A list of subnets in a Virtual Network.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualNetworkPeerings A list of peerings in a Virtual Network.
 */
public data class GetVirtualNetworkResult(
    public val addressSpace: AddressSpaceResponse? = null,
    public val bgpCommunities: VirtualNetworkBgpCommunitiesResponse? = null,
    public val ddosProtectionPlan: SubResourceResponse? = null,
    public val dhcpOptions: DhcpOptionsResponse? = null,
    public val enableDdosProtection: Boolean? = null,
    public val enableVmProtection: Boolean? = null,
    public val encryption: VirtualNetworkEncryptionResponse? = null,
    public val etag: String,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val flowLogs: List<FlowLogResponse>,
    public val flowTimeoutInMinutes: Int? = null,
    public val id: String? = null,
    public val ipAllocations: List<SubResourceResponse>? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val subnets: List<SubnetResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualNetworkPeerings: List<VirtualNetworkPeeringResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVirtualNetworkResult): GetVirtualNetworkResult = GetVirtualNetworkResult(
            addressSpace = javaType.addressSpace().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            bgpCommunities = javaType.bgpCommunities().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkBgpCommunitiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ddosProtectionPlan = javaType.ddosProtectionPlan().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dhcpOptions = javaType.dhcpOptions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.DhcpOptionsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            enableDdosProtection = javaType.enableDdosProtection().map({ args0 -> args0 }).orElse(null),
            enableVmProtection = javaType.enableVmProtection().map({ args0 -> args0 }).orElse(null),
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkEncryptionResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            flowLogs = javaType.flowLogs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.FlowLogResponse.Companion.toKotlin(args0)
                })
            }),
            flowTimeoutInMinutes = javaType.flowTimeoutInMinutes().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            ipAllocations = javaType.ipAllocations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            subnets = javaType.subnets().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualNetworkPeerings = javaType.virtualNetworkPeerings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkPeeringResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
