@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * VirtualRouter Resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property hostedGateway The Gateway on which VirtualRouter is hosted.
 * @property hostedSubnet The Subnet on which VirtualRouter is hosted.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property peerings List of references to VirtualRouterPeerings.
 * @property provisioningState The provisioning state of the resource.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualRouterAsn VirtualRouter ASN.
 * @property virtualRouterIps VirtualRouter IPs.
 */
public data class GetVirtualRouterResult(
    public val etag: String,
    public val hostedGateway: SubResourceResponse? = null,
    public val hostedSubnet: SubResourceResponse? = null,
    public val id: String? = null,
    public val location: String? = null,
    public val name: String,
    public val peerings: List<SubResourceResponse>,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualRouterAsn: Double? = null,
    public val virtualRouterIps: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVirtualRouterResult): GetVirtualRouterResult = GetVirtualRouterResult(
            etag = javaType.etag(),
            hostedGateway = javaType.hostedGateway().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hostedSubnet = javaType.hostedSubnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            peerings = javaType.peerings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualRouterAsn = javaType.virtualRouterAsn().map({ args0 -> args0 }).orElse(null),
            virtualRouterIps = javaType.virtualRouterIps().map({ args0 -> args0 }),
        )
    }
}
