@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * VirtualWAN Resource.
 * @property allowBranchToBranchTraffic True if branch to branch traffic is allowed.
 * @property allowVnetToVnetTraffic True if Vnet to Vnet traffic is allowed.
 * @property disableVpnEncryption Vpn encryption to be disabled or not.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property location Resource location.
 * @property name Resource name.
 * @property office365LocalBreakoutCategory The office local breakout category.
 * @property provisioningState The provisioning state of the virtual WAN resource.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property virtualHubs List of VirtualHubs in the VirtualWAN.
 * @property vpnSites List of VpnSites in the VirtualWAN.
 */
public data class GetVirtualWanResult(
    public val allowBranchToBranchTraffic: Boolean? = null,
    public val allowVnetToVnetTraffic: Boolean? = null,
    public val disableVpnEncryption: Boolean? = null,
    public val etag: String,
    public val id: String? = null,
    public val location: String,
    public val name: String,
    public val office365LocalBreakoutCategory: String,
    public val provisioningState: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val virtualHubs: List<SubResourceResponse>,
    public val vpnSites: List<SubResourceResponse>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetVirtualWanResult): GetVirtualWanResult = GetVirtualWanResult(
            allowBranchToBranchTraffic = javaType.allowBranchToBranchTraffic().map({ args0 ->
                args0
            }).orElse(null),
            allowVnetToVnetTraffic = javaType.allowVnetToVnetTraffic().map({ args0 -> args0 }).orElse(null),
            disableVpnEncryption = javaType.disableVpnEncryption().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            office365LocalBreakoutCategory = javaType.office365LocalBreakoutCategory(),
            provisioningState = javaType.provisioningState(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            virtualHubs = javaType.virtualHubs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            vpnSites = javaType.vpnSites().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
