@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Describes a DNS zone.
 * @property etag The etag of the zone.
 * @property id Resource ID.
 * @property location Resource location.
 * @property maxNumberOfRecordSets The maximum number of record sets that can be created in this DNS zone.  This is a read-only property and any attempt to set this value will be ignored.
 * @property maxNumberOfRecordsPerRecordSet The maximum number of records per record set that can be created in this DNS zone.  This is a read-only property and any attempt to set this value will be ignored.
 * @property name Resource name.
 * @property nameServers The name servers for this DNS zone. This is a read-only property and any attempt to set this value will be ignored.
 * @property numberOfRecordSets The current number of record sets in this DNS zone.  This is a read-only property and any attempt to set this value will be ignored.
 * @property registrationVirtualNetworks A list of references to virtual networks that register hostnames in this DNS zone. This is a only when ZoneType is Private.
 * @property resolutionVirtualNetworks A list of references to virtual networks that resolve records in this DNS zone. This is a only when ZoneType is Private.
 * @property tags Resource tags.
 * @property type Resource type.
 * @property zoneType The type of this DNS zone (Public or Private).
 */
public data class GetZoneResult(
    public val etag: String? = null,
    public val id: String,
    public val location: String,
    public val maxNumberOfRecordSets: Double,
    public val maxNumberOfRecordsPerRecordSet: Double,
    public val name: String,
    public val nameServers: List<String>,
    public val numberOfRecordSets: Double,
    public val registrationVirtualNetworks: List<SubResourceResponse>? = null,
    public val resolutionVirtualNetworks: List<SubResourceResponse>? = null,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zoneType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.GetZoneResult): GetZoneResult = GetZoneResult(
            etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            location = javaType.location(),
            maxNumberOfRecordSets = javaType.maxNumberOfRecordSets(),
            maxNumberOfRecordsPerRecordSet = javaType.maxNumberOfRecordsPerRecordSet(),
            name = javaType.name(),
            nameServers = javaType.nameServers().map({ args0 -> args0 }),
            numberOfRecordSets = javaType.numberOfRecordSets(),
            registrationVirtualNetworks = javaType.registrationVirtualNetworks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            resolutionVirtualNetworks = javaType.resolutionVirtualNetworks().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zoneType = javaType.zoneType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
