@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An action that can manipulate an http header.
 * @property headerActionType Which type of manipulation to apply to the header.
 * @property headerName The name of the header this action will apply to.
 * @property value The value to update the given header name with. This value is not used if the actionType is Delete.
 */
public data class HeaderActionResponse(
    public val headerActionType: String,
    public val headerName: String,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.HeaderActionResponse): HeaderActionResponse = HeaderActionResponse(
            headerActionType = javaType.headerActionType(),
            headerName = javaType.headerName(),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
