@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IP addresses associated with azure firewall.
 * @property privateIPAddress Private IP Address associated with azure firewall.
 * @property publicIPs Public IP addresses associated with azure firewall.
 */
public data class HubIPAddressesResponse(
    public val privateIPAddress: String? = null,
    public val publicIPs: HubPublicIPAddressesResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.HubIPAddressesResponse): HubIPAddressesResponse = HubIPAddressesResponse(
            privateIPAddress = javaType.privateIPAddress().map({ args0 -> args0 }).orElse(null),
            publicIPs = javaType.publicIPs().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.HubPublicIPAddressesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
