@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IP configuration.
 * @property privateIpAddress Private IP address of the IP configuration.
 * @property privateIpAllocationMethod Private IP address allocation method.
 * @property subnet The reference to the subnet bound to the IP configuration.
 */
public data class InboundEndpointIPConfigurationResponse(
    public val privateIpAddress: String? = null,
    public val privateIpAllocationMethod: String? = null,
    public val subnet: SubResourceResponse,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.InboundEndpointIPConfigurationResponse): InboundEndpointIPConfigurationResponse = InboundEndpointIPConfigurationResponse(
            privateIpAddress = javaType.privateIpAddress().map({ args0 -> args0 }).orElse(null),
            privateIpAllocationMethod = javaType.privateIpAllocationMethod().map({ args0 ->
                args0
            }).orElse(null),
            subnet = javaType.subnet().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
        )
    }
}
