@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Inbound NAT pool of the load balancer.
 * @property backendPort The port used for internal connections on the endpoint. Acceptable values are between 1 and 65535.
 * @property enableFloatingIP Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
 * @property enableTcpReset Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property frontendIPConfiguration A reference to frontend IP addresses.
 * @property frontendPortRangeEnd The last port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65535.
 * @property frontendPortRangeStart The first port number in the range of external ports that will be used to provide Inbound Nat to NICs associated with a load balancer. Acceptable values range between 1 and 65534.
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
 * @property name The name of the resource that is unique within the set of inbound NAT pools used by the load balancer. This name can be used to access the resource.
 * @property protocol The reference to the transport protocol used by the inbound NAT pool.
 * @property provisioningState The provisioning state of the inbound NAT pool resource.
 * @property type Type of the resource.
 */
public data class InboundNatPoolResponse(
    public val backendPort: Int,
    public val enableFloatingIP: Boolean? = null,
    public val enableTcpReset: Boolean? = null,
    public val etag: String,
    public val frontendIPConfiguration: SubResourceResponse? = null,
    public val frontendPortRangeEnd: Int,
    public val frontendPortRangeStart: Int,
    public val id: String? = null,
    public val idleTimeoutInMinutes: Int? = null,
    public val name: String? = null,
    public val protocol: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.InboundNatPoolResponse): InboundNatPoolResponse = InboundNatPoolResponse(
            backendPort = javaType.backendPort(),
            enableFloatingIP = javaType.enableFloatingIP().map({ args0 -> args0 }).orElse(null),
            enableTcpReset = javaType.enableTcpReset().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            frontendIPConfiguration = javaType.frontendIPConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            frontendPortRangeEnd = javaType.frontendPortRangeEnd(),
            frontendPortRangeStart = javaType.frontendPortRangeStart(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            idleTimeoutInMinutes = javaType.idleTimeoutInMinutes().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
