@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Contains the IpTag associated with the object.
 * @property ipTagType The IP tag type. Example: FirstPartyUsage.
 * @property tag The value of the IP tag associated with the public IP. Example: SQL.
 */
public data class IpTagResponse(
    public val ipTagType: String? = null,
    public val tag: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.IpTagResponse): IpTagResponse = IpTagResponse(
            ipTagType = javaType.ipTagType().map({ args0 -> args0 }).orElse(null),
            tag = javaType.tag().map({ args0 -> args0 }).orElse(null),
        )
    }
}
