@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * IPv6 Circuit Connection properties for global reach.
 * @property addressPrefix /125 IP address space to carve out customer addresses for global reach.
 * @property circuitConnectionStatus Express Route Circuit connection state.
 */
public data class Ipv6CircuitConnectionConfigResponse(
    public val addressPrefix: String? = null,
    public val circuitConnectionStatus: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.Ipv6CircuitConnectionConfigResponse): Ipv6CircuitConnectionConfigResponse = Ipv6CircuitConnectionConfigResponse(
            addressPrefix = javaType.addressPrefix().map({ args0 -> args0 }).orElse(null),
            circuitConnectionStatus = javaType.circuitConnectionStatus(),
        )
    }
}
