@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The response to an enumeration operation on sub-resources.
 * @property nextLink The continuation token for the next page of results.
 * @property value Enumeration of the sub-resources.
 */
public data class ListDnsResolverByVirtualNetworkResult(
    public val nextLink: String,
    public val `value`: List<SubResourceResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ListDnsResolverByVirtualNetworkResult): ListDnsResolverByVirtualNetworkResult = ListDnsResolverByVirtualNetworkResult(
            nextLink = javaType.nextLink(),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
