@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.Suppress
import kotlin.collections.List

/**
 * Query result
 * @property matchingRecordsCount Number of total records matching the query.
 * @property signatures Array containing the results of the query
 */
public data class ListFirewallPolicyIdpsSignatureResult(
    public val matchingRecordsCount: Double? = null,
    public val signatures: List<SingleQueryResultResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ListFirewallPolicyIdpsSignatureResult): ListFirewallPolicyIdpsSignatureResult = ListFirewallPolicyIdpsSignatureResult(
            matchingRecordsCount = javaType.matchingRecordsCount().map({ args0 -> args0 }).orElse(null),
            signatures = javaType.signatures().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SingleQueryResultResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
