@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A list of Network Manager Deployment Status
 * @property skipToken When present, the value can be passed to a subsequent query call (together with the same query and scopes used in the current request) to retrieve the next page of data.
 * @property value Gets a page of Network Manager Deployment Status
 */
public data class ListNetworkManagerDeploymentStatusResult(
    public val skipToken: String? = null,
    public val `value`: List<NetworkManagerDeploymentStatusResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ListNetworkManagerDeploymentStatusResult): ListNetworkManagerDeploymentStatusResult = ListNetworkManagerDeploymentStatusResult(
            skipToken = javaType.skipToken().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkManagerDeploymentStatusResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
