@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Load balancer backend addresses.
 * @property adminState A list of administrative states which once set can override health probe so that Load Balancer will always forward new connections to backend, or deny new connections and reset existing connections.
 * @property inboundNatRulesPortMapping Collection of inbound NAT rule port mappings.
 * @property ipAddress IP Address belonging to the referenced virtual network.
 * @property loadBalancerFrontendIPConfiguration Reference to the frontend ip address configuration defined in regional loadbalancer.
 * @property name Name of the backend address.
 * @property networkInterfaceIPConfiguration Reference to IP address defined in network interfaces.
 * @property subnet Reference to an existing subnet.
 * @property virtualNetwork Reference to an existing virtual network.
 */
public data class LoadBalancerBackendAddressResponse(
    public val adminState: String? = null,
    public val inboundNatRulesPortMapping: List<NatRulePortMappingResponse>,
    public val ipAddress: String? = null,
    public val loadBalancerFrontendIPConfiguration: SubResourceResponse? = null,
    public val name: String? = null,
    public val networkInterfaceIPConfiguration: SubResourceResponse,
    public val subnet: SubResourceResponse? = null,
    public val virtualNetwork: SubResourceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.LoadBalancerBackendAddressResponse): LoadBalancerBackendAddressResponse = LoadBalancerBackendAddressResponse(
            adminState = javaType.adminState().map({ args0 -> args0 }).orElse(null),
            inboundNatRulesPortMapping = javaType.inboundNatRulesPortMapping().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NatRulePortMappingResponse.Companion.toKotlin(args0)
                })
            }),
            ipAddress = javaType.ipAddress().map({ args0 -> args0 }).orElse(null),
            loadBalancerFrontendIPConfiguration = javaType.loadBalancerFrontendIPConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            networkInterfaceIPConfiguration = javaType.networkInterfaceIPConfiguration().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            virtualNetwork = javaType.virtualNetwork().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
