@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * SKU of a load balancer.
 * @property name Name of a load balancer SKU.
 * @property tier Tier of a load balancer SKU.
 */
public data class LoadBalancerSkuResponse(
    public val name: String? = null,
    public val tier: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.LoadBalancerSkuResponse): LoadBalancerSkuResponse = LoadBalancerSkuResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            tier = javaType.tier().map({ args0 -> args0 }).orElse(null),
        )
    }
}
