@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A load balancing rule for a load balancer.
 * @property backendAddressPool A reference to a pool of DIPs. Inbound traffic is randomly load balanced across IPs in the backend IPs.
 * @property backendAddressPools An array of references to pool of DIPs.
 * @property backendPort The port used for internal connections on the endpoint. Acceptable values are between 0 and 65535. Note that value 0 enables "Any Port".
 * @property disableOutboundSnat Configures SNAT for the VMs in the backend pool to use the publicIP address specified in the frontend of the load balancing rule.
 * @property enableFloatingIP Configures a virtual machine's endpoint for the floating IP capability required to configure a SQL AlwaysOn Availability Group. This setting is required when using the SQL AlwaysOn Availability Groups in SQL server. This setting can't be changed after you create the endpoint.
 * @property enableTcpReset Receive bidirectional TCP Reset on TCP flow idle timeout or unexpected connection termination. This element is only used when the protocol is set to TCP.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property frontendIPConfiguration A reference to frontend IP addresses.
 * @property frontendPort The port for the external endpoint. Port numbers for each rule must be unique within the Load Balancer. Acceptable values are between 0 and 65534. Note that value 0 enables "Any Port".
 * @property id Resource ID.
 * @property idleTimeoutInMinutes The timeout for the TCP idle connection. The value can be set between 4 and 30 minutes. The default value is 4 minutes. This element is only used when the protocol is set to TCP.
 * @property loadDistribution The load distribution policy for this rule.
 * @property name The name of the resource that is unique within the set of load balancing rules used by the load balancer. This name can be used to access the resource.
 * @property probe The reference to the load balancer probe used by the load balancing rule.
 * @property protocol The reference to the transport protocol used by the load balancing rule.
 * @property provisioningState The provisioning state of the load balancing rule resource.
 * @property type Type of the resource.
 */
public data class LoadBalancingRuleResponse(
    public val backendAddressPool: SubResourceResponse? = null,
    public val backendAddressPools: List<SubResourceResponse>? = null,
    public val backendPort: Int? = null,
    public val disableOutboundSnat: Boolean? = null,
    public val enableFloatingIP: Boolean? = null,
    public val enableTcpReset: Boolean? = null,
    public val etag: String,
    public val frontendIPConfiguration: SubResourceResponse? = null,
    public val frontendPort: Int,
    public val id: String? = null,
    public val idleTimeoutInMinutes: Int? = null,
    public val loadDistribution: String? = null,
    public val name: String? = null,
    public val probe: SubResourceResponse? = null,
    public val protocol: String,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.LoadBalancingRuleResponse): LoadBalancingRuleResponse = LoadBalancingRuleResponse(
            backendAddressPool = javaType.backendAddressPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            backendAddressPools = javaType.backendAddressPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            backendPort = javaType.backendPort().map({ args0 -> args0 }).orElse(null),
            disableOutboundSnat = javaType.disableOutboundSnat().map({ args0 -> args0 }).orElse(null),
            enableFloatingIP = javaType.enableFloatingIP().map({ args0 -> args0 }).orElse(null),
            enableTcpReset = javaType.enableTcpReset().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            frontendIPConfiguration = javaType.frontendIPConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            frontendPort = javaType.frontendPort(),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            idleTimeoutInMinutes = javaType.idleTimeoutInMinutes().map({ args0 -> args0 }).orElse(null),
            loadDistribution = javaType.loadDistribution().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            probe = javaType.probe().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            protocol = javaType.protocol(),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
