@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Load balancing settings for a backend pool
 * @property additionalLatencyMilliseconds The additional latency in milliseconds for probes to fall into the lowest latency bucket
 * @property id Resource ID.
 * @property name Resource name.
 * @property resourceState Resource status.
 * @property sampleSize The number of samples to consider for load balancing decisions
 * @property successfulSamplesRequired The number of samples within the sample period that must succeed
 * @property type Resource type.
 */
public data class LoadBalancingSettingsModelResponse(
    public val additionalLatencyMilliseconds: Int? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val resourceState: String,
    public val sampleSize: Int? = null,
    public val successfulSamplesRequired: Int? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.LoadBalancingSettingsModelResponse): LoadBalancingSettingsModelResponse = LoadBalancingSettingsModelResponse(
            additionalLatencyMilliseconds = javaType.additionalLatencyMilliseconds().map({ args0 ->
                args0
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            resourceState = javaType.resourceState(),
            sampleSize = javaType.sampleSize().map({ args0 -> args0 }).orElse(null),
            successfulSamplesRequired = javaType.successfulSamplesRequired().map({ args0 ->
                args0
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
