@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A common class for general resource information.
 * @property bgpSettings Local network gateway's BGP speaker settings.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property fqdn FQDN of local network gateway.
 * @property gatewayIpAddress IP address of local network gateway.
 * @property id Resource ID.
 * @property localNetworkAddressSpace Local network site address space.
 * @property location Resource location.
 * @property name Resource name.
 * @property provisioningState The provisioning state of the local network gateway resource.
 * @property resourceGuid The resource GUID property of the local network gateway resource.
 * @property tags Resource tags.
 * @property type Resource type.
 */
public data class LocalNetworkGatewayResponse(
    public val bgpSettings: BgpSettingsResponse? = null,
    public val etag: String,
    public val fqdn: String? = null,
    public val gatewayIpAddress: String? = null,
    public val id: String? = null,
    public val localNetworkAddressSpace: AddressSpaceResponse? = null,
    public val location: String? = null,
    public val name: String,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.LocalNetworkGatewayResponse): LocalNetworkGatewayResponse = LocalNetworkGatewayResponse(
            bgpSettings = javaType.bgpSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.BgpSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            etag = javaType.etag(),
            fqdn = javaType.fqdn().map({ args0 -> args0 }).orElse(null),
            gatewayIpAddress = javaType.gatewayIpAddress().map({ args0 -> args0 }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            localNetworkAddressSpace = javaType.localNetworkAddressSpace().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.AddressSpaceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
