@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Defines a managed rule group override setting.
 * @property action Describes the override action to be applied when rule matches.
 * @property ruleId Identifier for the managed rule.
 * @property state The state of the managed rule. Defaults to Disabled if not specified.
 */
public data class ManagedRuleOverrideResponse(
    public val action: String? = null,
    public val ruleId: String,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ManagedRuleOverrideResponse): ManagedRuleOverrideResponse = ManagedRuleOverrideResponse(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            ruleId = javaType.ruleId(),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
