@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Identity for the resource.
 * @property principalId The principal id of the system assigned identity. This property will only be provided for a system assigned identity.
 * @property tenantId The tenant id of the system assigned identity. This property will only be provided for a system assigned identity.
 * @property type The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove any identities from the virtual machine.
 * @property userAssignedIdentities The list of user identities associated with resource. The user identity dictionary key references will be ARM resource ids in the form: '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
 */
public data class ManagedServiceIdentityResponse(
    public val principalId: String,
    public val tenantId: String,
    public val type: String? = null,
    public val userAssignedIdentities: Map<String, ManagedServiceIdentityResponseUserAssignedIdentities>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.ManagedServiceIdentityResponse): ManagedServiceIdentityResponse = ManagedServiceIdentityResponse(
            principalId = javaType.principalId(),
            tenantId = javaType.tenantId(),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            userAssignedIdentities = javaType.userAssignedIdentities().map({ args0 ->
                args0.key.to(
                    args0.value.let({ args0 ->
                        com.pulumi.azurenative.network.kotlin.outputs.ManagedServiceIdentityResponseUserAssignedIdentities.Companion.toKotlin(args0)
                    }),
                )
            }).toMap(),
        )
    }
}
