@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Class containing endpoint monitoring settings in a Traffic Manager profile.
 * @property customHeaders List of custom headers.
 * @property expectedStatusCodeRanges List of expected status code ranges.
 * @property intervalInSeconds The monitor interval for endpoints in this profile. This is the interval at which Traffic Manager will check the health of each endpoint in this profile.
 * @property path The path relative to the endpoint domain name used to probe for endpoint health.
 * @property port The TCP port used to probe for endpoint health.
 * @property profileMonitorStatus The profile-level monitoring status of the Traffic Manager profile.
 * @property protocol The protocol (HTTP, HTTPS or TCP) used to probe for endpoint health.
 * @property timeoutInSeconds The monitor timeout for endpoints in this profile. This is the time that Traffic Manager allows endpoints in this profile to response to the health check.
 * @property toleratedNumberOfFailures The number of consecutive failed health check that Traffic Manager tolerates before declaring an endpoint in this profile Degraded after the next failed health check.
 */
public data class MonitorConfigResponse(
    public val customHeaders: List<MonitorConfigResponseCustomHeaders>? = null,
    public val expectedStatusCodeRanges: List<MonitorConfigResponseExpectedStatusCodeRanges>? = null,
    public val intervalInSeconds: Double? = null,
    public val path: String? = null,
    public val port: Double? = null,
    public val profileMonitorStatus: String? = null,
    public val protocol: String? = null,
    public val timeoutInSeconds: Double? = null,
    public val toleratedNumberOfFailures: Double? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.MonitorConfigResponse): MonitorConfigResponse = MonitorConfigResponse(
            customHeaders = javaType.customHeaders().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.MonitorConfigResponseCustomHeaders.Companion.toKotlin(args0)
                })
            }),
            expectedStatusCodeRanges = javaType.expectedStatusCodeRanges().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.MonitorConfigResponseExpectedStatusCodeRanges.Companion.toKotlin(args0)
                })
            }),
            intervalInSeconds = javaType.intervalInSeconds().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            profileMonitorStatus = javaType.profileMonitorStatus().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            timeoutInSeconds = javaType.timeoutInSeconds().map({ args0 -> args0 }).orElse(null),
            toleratedNumberOfFailures = javaType.toleratedNumberOfFailures().map({ args0 ->
                args0
            }).orElse(null),
        )
    }
}
