@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 * Min and max value of a status code range.
 * @property max Max status code.
 * @property min Min status code.
 */
public data class MonitorConfigResponseExpectedStatusCodeRanges(
    public val max: Int? = null,
    public val min: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.MonitorConfigResponseExpectedStatusCodeRanges): MonitorConfigResponseExpectedStatusCodeRanges =
            MonitorConfigResponseExpectedStatusCodeRanges(
                max = javaType.max().map({ args0 -> args0 }).orElse(null),
                min = javaType.min().map({ args0 -> args0 }).orElse(null),
            )
    }
}
