@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * PrivateLinkConnection properties for the network interface.
 * @property fqdns List of FQDNs for current private link connection.
 * @property groupId The group ID for current private link connection.
 * @property requiredMemberName The required member name for current private link connection.
 */
public data class NetworkInterfaceIPConfigurationPrivateLinkConnectionPropertiesResponse(
    public val fqdns: List<String>,
    public val groupId: String,
    public val requiredMemberName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.NetworkInterfaceIPConfigurationPrivateLinkConnectionPropertiesResponse): NetworkInterfaceIPConfigurationPrivateLinkConnectionPropertiesResponse =
            NetworkInterfaceIPConfigurationPrivateLinkConnectionPropertiesResponse(
                fqdns = javaType.fqdns().map({ args0 -> args0 }),
                groupId = javaType.groupId(),
                requiredMemberName = javaType.requiredMemberName(),
            )
    }
}
