@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * IPConfiguration in a network interface.
 * @property applicationGatewayBackendAddressPools The reference to ApplicationGatewayBackendAddressPool resource.
 * @property applicationSecurityGroups Application security groups in which the IP configuration is included.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property gatewayLoadBalancer The reference to gateway load balancer frontend IP.
 * @property id Resource ID.
 * @property loadBalancerBackendAddressPools The reference to LoadBalancerBackendAddressPool resource.
 * @property loadBalancerInboundNatRules A list of references of LoadBalancerInboundNatRules.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property primary Whether this is a primary customer address on the network interface.
 * @property privateIPAddress Private IP address of the IP configuration.
 * @property privateIPAddressVersion Whether the specific IP configuration is IPv4 or IPv6. Default is IPv4.
 * @property privateIPAllocationMethod The private IP address allocation method.
 * @property privateLinkConnectionProperties PrivateLinkConnection properties for the network interface.
 * @property provisioningState The provisioning state of the network interface IP configuration.
 * @property publicIPAddress Public IP address bound to the IP configuration.
 * @property subnet Subnet bound to the IP configuration.
 * @property type Resource type.
 * @property virtualNetworkTaps The reference to Virtual Network Taps.
 */
public data class NetworkInterfaceIPConfigurationResponse(
    public val applicationGatewayBackendAddressPools: List<ApplicationGatewayBackendAddressPoolResponse>? = null,
    public val applicationSecurityGroups: List<ApplicationSecurityGroupResponse>? = null,
    public val etag: String,
    public val gatewayLoadBalancer: SubResourceResponse? = null,
    public val id: String? = null,
    public val loadBalancerBackendAddressPools: List<BackendAddressPoolResponse>? = null,
    public val loadBalancerInboundNatRules: List<InboundNatRuleResponse>? = null,
    public val name: String? = null,
    public val primary: Boolean? = null,
    public val privateIPAddress: String? = null,
    public val privateIPAddressVersion: String? = null,
    public val privateIPAllocationMethod: String? = null,
    public val privateLinkConnectionProperties: NetworkInterfaceIPConfigurationPrivateLinkConnectionPropertiesResponse,
    public val provisioningState: String,
    public val publicIPAddress: PublicIPAddressResponse? = null,
    public val subnet: SubnetResponse? = null,
    public val type: String? = null,
    public val virtualNetworkTaps: List<VirtualNetworkTapResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.NetworkInterfaceIPConfigurationResponse): NetworkInterfaceIPConfigurationResponse = NetworkInterfaceIPConfigurationResponse(
            applicationGatewayBackendAddressPools = javaType.applicationGatewayBackendAddressPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationGatewayBackendAddressPoolResponse.Companion.toKotlin(args0)
                })
            }),
            applicationSecurityGroups = javaType.applicationSecurityGroups().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ApplicationSecurityGroupResponse.Companion.toKotlin(args0)
                })
            }),
            etag = javaType.etag(),
            gatewayLoadBalancer = javaType.gatewayLoadBalancer().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            loadBalancerBackendAddressPools = javaType.loadBalancerBackendAddressPools().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.BackendAddressPoolResponse.Companion.toKotlin(args0)
                })
            }),
            loadBalancerInboundNatRules = javaType.loadBalancerInboundNatRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.InboundNatRuleResponse.Companion.toKotlin(args0)
                })
            }),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            primary = javaType.primary().map({ args0 -> args0 }).orElse(null),
            privateIPAddress = javaType.privateIPAddress().map({ args0 -> args0 }).orElse(null),
            privateIPAddressVersion = javaType.privateIPAddressVersion().map({ args0 -> args0 }).orElse(null),
            privateIPAllocationMethod = javaType.privateIPAllocationMethod().map({ args0 ->
                args0
            }).orElse(null),
            privateLinkConnectionProperties = javaType.privateLinkConnectionProperties().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationPrivateLinkConnectionPropertiesResponse.Companion.toKotlin(args0)
            }),
            provisioningState = javaType.provisioningState(),
            publicIPAddress = javaType.publicIPAddress().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PublicIPAddressResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubnetResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type().map({ args0 -> args0 }).orElse(null),
            virtualNetworkTaps = javaType.virtualNetworkTaps().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.VirtualNetworkTapResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
