@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * A network interface in a resource group.
 * @property auxiliaryMode Auxiliary mode of Network Interface resource.
 * @property auxiliarySku Auxiliary sku of Network Interface resource.
 * @property disableTcpStateTracking Indicates whether to disable tcp state tracking.
 * @property dnsSettings The DNS settings in network interface.
 * @property dscpConfiguration A reference to the dscp configuration to which the network interface is linked.
 * @property enableAcceleratedNetworking If the network interface is configured for accelerated networking. Not applicable to VM sizes which require accelerated networking.
 * @property enableIPForwarding Indicates whether IP forwarding is enabled on this network interface.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property extendedLocation The extended location of the network interface.
 * @property hostedWorkloads A list of references to linked BareMetal resources.
 * @property id Resource ID.
 * @property interfaceEndpoint A reference to the interface endpoint to which the network interface is linked.
 * @property ipConfigurations A list of IPConfigurations of the network interface.
 * @property location Resource location.
 * @property macAddress The MAC address of the network interface.
 * @property migrationPhase Migration phase of Network Interface resource.
 * @property name Resource name.
 * @property networkSecurityGroup The reference to the NetworkSecurityGroup resource.
 * @property nicType Type of Network Interface resource.
 * @property primary Whether this is a primary network interface on a virtual machine.
 * @property privateEndpoint A reference to the private endpoint to which the network interface is linked.
 * @property privateLinkService Privatelinkservice of the network interface resource.
 * @property provisioningState The provisioning state of the network interface resource.
 * @property resourceGuid The resource GUID property of the network interface resource.
 * @property tags Resource tags.
 * @property tapConfigurations A list of TapConfigurations of the network interface.
 * @property type Resource type.
 * @property virtualMachine The reference to a virtual machine.
 * @property vnetEncryptionSupported Whether the virtual machine this nic is attached to supports encryption.
 * @property workloadType WorkloadType of the NetworkInterface for BareMetal resources
 */
public data class NetworkInterfaceResponse(
    public val auxiliaryMode: String? = null,
    public val auxiliarySku: String? = null,
    public val disableTcpStateTracking: Boolean? = null,
    public val dnsSettings: NetworkInterfaceDnsSettingsResponse? = null,
    public val dscpConfiguration: SubResourceResponse,
    public val enableAcceleratedNetworking: Boolean? = null,
    public val enableIPForwarding: Boolean? = null,
    public val etag: String,
    public val extendedLocation: ExtendedLocationResponse? = null,
    public val hostedWorkloads: List<String>,
    public val id: String? = null,
    public val interfaceEndpoint: InterfaceEndpointResponse? = null,
    public val ipConfigurations: List<NetworkInterfaceIPConfigurationResponse>? = null,
    public val location: String? = null,
    public val macAddress: String,
    public val migrationPhase: String? = null,
    public val name: String,
    public val networkSecurityGroup: NetworkSecurityGroupResponse? = null,
    public val nicType: String? = null,
    public val primary: Boolean,
    public val privateEndpoint: PrivateEndpointResponse,
    public val privateLinkService: PrivateLinkServiceResponse? = null,
    public val provisioningState: String,
    public val resourceGuid: String,
    public val tags: Map<String, String>? = null,
    public val tapConfigurations: List<NetworkInterfaceTapConfigurationResponse>,
    public val type: String,
    public val virtualMachine: SubResourceResponse,
    public val vnetEncryptionSupported: Boolean,
    public val workloadType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.NetworkInterfaceResponse): NetworkInterfaceResponse = NetworkInterfaceResponse(
            auxiliaryMode = javaType.auxiliaryMode().map({ args0 -> args0 }).orElse(null),
            auxiliarySku = javaType.auxiliarySku().map({ args0 -> args0 }).orElse(null),
            disableTcpStateTracking = javaType.disableTcpStateTracking().map({ args0 -> args0 }).orElse(null),
            dnsSettings = javaType.dnsSettings().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceDnsSettingsResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            dscpConfiguration = javaType.dscpConfiguration().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
            enableAcceleratedNetworking = javaType.enableAcceleratedNetworking().map({ args0 ->
                args0
            }).orElse(null),
            enableIPForwarding = javaType.enableIPForwarding().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            extendedLocation = javaType.extendedLocation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.ExtendedLocationResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            hostedWorkloads = javaType.hostedWorkloads().map({ args0 -> args0 }),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            interfaceEndpoint = javaType.interfaceEndpoint().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.InterfaceEndpointResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            ipConfigurations = javaType.ipConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceIPConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            macAddress = javaType.macAddress(),
            migrationPhase = javaType.migrationPhase().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            networkSecurityGroup = javaType.networkSecurityGroup().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkSecurityGroupResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            nicType = javaType.nicType().map({ args0 -> args0 }).orElse(null),
            primary = javaType.primary(),
            privateEndpoint = javaType.privateEndpoint().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.PrivateEndpointResponse.Companion.toKotlin(args0)
            }),
            privateLinkService = javaType.privateLinkService().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PrivateLinkServiceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            resourceGuid = javaType.resourceGuid(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            tapConfigurations = javaType.tapConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.NetworkInterfaceTapConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            type = javaType.type(),
            virtualMachine = javaType.virtualMachine().let({ args0 ->
                com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
            }),
            vnetEncryptionSupported = javaType.vnetEncryptionSupported(),
            workloadType = javaType.workloadType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
