@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 * Office365 breakout categories.
 * @property allow Flag to control allow category.
 * @property default Flag to control default category.
 * @property optimize Flag to control optimize category.
 */
public data class O365BreakOutCategoryPoliciesResponse(
    public val allow: Boolean? = null,
    public val default: Boolean? = null,
    public val optimize: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.O365BreakOutCategoryPoliciesResponse): O365BreakOutCategoryPoliciesResponse = O365BreakOutCategoryPoliciesResponse(
            allow = javaType.allow().map({ args0 -> args0 }).orElse(null),
            default = javaType.default_().map({ args0 -> args0 }).orElse(null),
            optimize = javaType.optimize().map({ args0 -> args0 }).orElse(null),
        )
    }
}
