@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Radius Server root certificate of P2SVpnServerConfiguration.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property provisioningState The provisioning state of the radius server root certificate resource.
 * @property publicCertData The certificate public data.
 */
public data class P2SVpnServerConfigRadiusServerRootCertificateResponse(
    public val etag: String? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val provisioningState: String,
    public val publicCertData: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.P2SVpnServerConfigRadiusServerRootCertificateResponse): P2SVpnServerConfigRadiusServerRootCertificateResponse =
            P2SVpnServerConfigRadiusServerRootCertificateResponse(
                etag = javaType.etag().map({ args0 -> args0 }).orElse(null),
                id = javaType.id().map({ args0 -> args0 }).orElse(null),
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                provisioningState = javaType.provisioningState(),
                publicCertData = javaType.publicCertData(),
            )
    }
}
