@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Filter that is applied to packet capture request. Multiple filters can be applied.
 * @property localIPAddress Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5"? for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
 * @property localPort Local port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
 * @property protocol Protocol to be filtered on.
 * @property remoteIPAddress Local IP Address to be filtered on. Notation: "127.0.0.1" for single address entry. "127.0.0.1-127.0.0.255" for range. "127.0.0.1;127.0.0.5;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
 * @property remotePort Remote port to be filtered on. Notation: "80" for single port entry."80-85" for range. "80;443;" for multiple entries. Multiple ranges not currently supported. Mixing ranges with multiple entries not currently supported. Default = null.
 */
public data class PacketCaptureFilterResponse(
    public val localIPAddress: String? = null,
    public val localPort: String? = null,
    public val protocol: String? = null,
    public val remoteIPAddress: String? = null,
    public val remotePort: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PacketCaptureFilterResponse): PacketCaptureFilterResponse = PacketCaptureFilterResponse(
            localIPAddress = javaType.localIPAddress().map({ args0 -> args0 }).orElse(null),
            localPort = javaType.localPort().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            remoteIPAddress = javaType.remoteIPAddress().map({ args0 -> args0 }).orElse(null),
            remotePort = javaType.remotePort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
