@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The storage location for a packet capture session.
 * @property filePath A valid local path on the targeting VM. Must include the name of the capture file (*.cap). For linux virtual machine it must start with /var/captures. Required if no storage ID is provided, otherwise optional.
 * @property storageId The ID of the storage account to save the packet capture session. Required if no local file path is provided.
 * @property storagePath The URI of the storage path to save the packet capture. Must be a well-formed URI describing the location to save the packet capture.
 */
public data class PacketCaptureStorageLocationResponse(
    public val filePath: String? = null,
    public val storageId: String? = null,
    public val storagePath: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PacketCaptureStorageLocationResponse): PacketCaptureStorageLocationResponse = PacketCaptureStorageLocationResponse(
            filePath = javaType.filePath().map({ args0 -> args0 }).orElse(null),
            storageId = javaType.storageId().map({ args0 -> args0 }).orElse(null),
            storagePath = javaType.storagePath().map({ args0 -> args0 }).orElse(null),
        )
    }
}
