@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Peer Express Route Circuit Connection in an ExpressRouteCircuitPeering resource.
 * @property addressPrefix /29 IP address space to carve out Customer addresses for tunnels.
 * @property authResourceGuid The resource guid of the authorization used for the express route circuit connection.
 * @property circuitConnectionStatus Express Route Circuit connection state.
 * @property connectionName The name of the express route circuit connection resource.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property expressRouteCircuitPeering Reference to Express Route Circuit Private Peering Resource of the circuit.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 * @property peerExpressRouteCircuitPeering Reference to Express Route Circuit Private Peering Resource of the peered circuit.
 * @property provisioningState The provisioning state of the peer express route circuit connection resource.
 * @property type Type of the resource.
 */
public data class PeerExpressRouteCircuitConnectionResponse(
    public val addressPrefix: String? = null,
    public val authResourceGuid: String? = null,
    public val circuitConnectionStatus: String,
    public val connectionName: String? = null,
    public val etag: String,
    public val expressRouteCircuitPeering: SubResourceResponse? = null,
    public val id: String? = null,
    public val name: String? = null,
    public val peerExpressRouteCircuitPeering: SubResourceResponse? = null,
    public val provisioningState: String,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PeerExpressRouteCircuitConnectionResponse): PeerExpressRouteCircuitConnectionResponse = PeerExpressRouteCircuitConnectionResponse(
            addressPrefix = javaType.addressPrefix().map({ args0 -> args0 }).orElse(null),
            authResourceGuid = javaType.authResourceGuid().map({ args0 -> args0 }).orElse(null),
            circuitConnectionStatus = javaType.circuitConnectionStatus(),
            connectionName = javaType.connectionName().map({ args0 -> args0 }).orElse(null),
            etag = javaType.etag(),
            expressRouteCircuitPeering = javaType.expressRouteCircuitPeering().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            id = javaType.id().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            peerExpressRouteCircuitPeering = javaType.peerExpressRouteCircuitPeering().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            type = javaType.type(),
        )
    }
}
