@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property id NSP id in the ARM id format.
 * @property location Location of the NSP supplied.
 * @property perimeterGuid Resource guid of the NSP supplied.
 */
public data class PerimeterBasedAccessRuleResponse(
    public val id: String,
    public val location: String,
    public val perimeterGuid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PerimeterBasedAccessRuleResponse): PerimeterBasedAccessRuleResponse = PerimeterBasedAccessRuleResponse(
            id = javaType.id(),
            location = javaType.location(),
            perimeterGuid = javaType.perimeterGuid(),
        )
    }
}
