@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Defines contents of a web application firewall global configuration.
 * @property customBlockResponseBody If the action type is block, customer can override the response body. The body must be specified in base64 encoding.
 * @property customBlockResponseStatusCode If the action type is block, customer can override the response status code.
 * @property fileUploadEnforcement Whether allow WAF to enforce file upload limits.
 * @property fileUploadLimitInMb Maximum file upload size in Mb for WAF.
 * @property logScrubbing To scrub sensitive log fields
 * @property maxRequestBodySizeInKb Maximum request body size in Kb for WAF.
 * @property mode The mode of the policy.
 * @property requestBodyCheck Whether to allow WAF to check request Body.
 * @property requestBodyEnforcement Whether allow WAF to enforce request body limits.
 * @property requestBodyInspectLimitInKB Max inspection limit in KB for request body inspection for WAF.
 * @property state The state of the policy.
 */
public data class PolicySettingsResponse(
    public val customBlockResponseBody: String? = null,
    public val customBlockResponseStatusCode: Int? = null,
    public val fileUploadEnforcement: Boolean? = null,
    public val fileUploadLimitInMb: Int? = null,
    public val logScrubbing: PolicySettingsResponseLogScrubbing? = null,
    public val maxRequestBodySizeInKb: Int? = null,
    public val mode: String? = null,
    public val requestBodyCheck: Boolean? = null,
    public val requestBodyEnforcement: Boolean? = null,
    public val requestBodyInspectLimitInKB: Int? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PolicySettingsResponse): PolicySettingsResponse = PolicySettingsResponse(
            customBlockResponseBody = javaType.customBlockResponseBody().map({ args0 -> args0 }).orElse(null),
            customBlockResponseStatusCode = javaType.customBlockResponseStatusCode().map({ args0 ->
                args0
            }).orElse(null),
            fileUploadEnforcement = javaType.fileUploadEnforcement().map({ args0 -> args0 }).orElse(null),
            fileUploadLimitInMb = javaType.fileUploadLimitInMb().map({ args0 -> args0 }).orElse(null),
            logScrubbing = javaType.logScrubbing().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.PolicySettingsResponseLogScrubbing.Companion.toKotlin(args0)
                })
            }).orElse(null),
            maxRequestBodySizeInKb = javaType.maxRequestBodySizeInKb().map({ args0 -> args0 }).orElse(null),
            mode = javaType.mode().map({ args0 -> args0 }).orElse(null),
            requestBodyCheck = javaType.requestBodyCheck().map({ args0 -> args0 }).orElse(null),
            requestBodyEnforcement = javaType.requestBodyEnforcement().map({ args0 -> args0 }).orElse(null),
            requestBodyInspectLimitInKB = javaType.requestBodyInspectLimitInKB().map({ args0 ->
                args0
            }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
