@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * To scrub sensitive log fields
 * @property scrubbingRules The rules that are applied to the logs for scrubbing.
 * @property state State of the log scrubbing config. Default value is Enabled.
 */
public data class PolicySettingsResponseLogScrubbing(
    public val scrubbingRules: List<WebApplicationFirewallScrubbingRulesResponse>? = null,
    public val state: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PolicySettingsResponseLogScrubbing): PolicySettingsResponseLogScrubbing = PolicySettingsResponseLogScrubbing(
            scrubbingRules = javaType.scrubbingRules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.WebApplicationFirewallScrubbingRulesResponse.Companion.toKotlin(args0)
                })
            }),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
        )
    }
}
