@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * An IP Configuration of the private endpoint.
 * @property etag A unique read-only string that changes whenever the resource is updated.
 * @property groupId The ID of a group obtained from the remote resource that this private endpoint should connect to.
 * @property memberName The member name of a group obtained from the remote resource that this private endpoint should connect to.
 * @property name The name of the resource that is unique within a resource group.
 * @property privateIPAddress A private ip address obtained from the private endpoint's subnet.
 * @property type The resource type.
 */
public data class PrivateEndpointIPConfigurationResponse(
    public val etag: String,
    public val groupId: String? = null,
    public val memberName: String? = null,
    public val name: String? = null,
    public val privateIPAddress: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PrivateEndpointIPConfigurationResponse): PrivateEndpointIPConfigurationResponse = PrivateEndpointIPConfigurationResponse(
            etag = javaType.etag(),
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            memberName = javaType.memberName().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            privateIPAddress = javaType.privateIPAddress().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
