@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The list of RouteTables to advertise the routes to.
 * @property ids The list of resource ids of all the RouteTables.
 * @property labels The list of labels.
 */
public data class PropagatedRouteTableResponse(
    public val ids: List<SubResourceResponse>? = null,
    public val labels: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.network.outputs.PropagatedRouteTableResponse): PropagatedRouteTableResponse = PropagatedRouteTableResponse(
            ids = javaType.ids().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.network.kotlin.outputs.SubResourceResponse.Companion.toKotlin(args0)
                })
            }),
            labels = javaType.labels().map({ args0 -> args0 }),
        )
    }
}
